# Updater script for DigiLEAN Connect Windows service

$local_folder = "D:\programs\DigiLean.Connect\"
$extract_to = $local_folder + "unzipped\"
$backup_to = $local_folder + "backup"

Write-Output "######### DigiLEAN Connect WindowsService update #######################"
## backup folder - create or empty
if (Test-Path -Path $backup_to) {
    Write-Output "$backup_to exists"
    Write-Output "Remove old files in $backup_to"
    $remove_filter = $backup_to + "\*"
    Remove-Item $remove_filter
} else {
    "$backup_to doesn't exist. Create"
    New-Item -Path $local_folder -Name "backup" -ItemType "directory"
}
## extract to folder - empty if has files
if (Test-Path -Path $extract_to) {
    Write-Output "$extract_to exists"
    Write-Output "Remove old files in $extract_to"
    $remove_filter = $extract_to + "\*"
    Remove-Item $remove_filter
} else {
    "$extract_to doesn't exist. Create"
    New-Item -Path $local_folder -Name "unzipped" -ItemType "directory"
}

$url = "https://connector.digilean.tools/_DigiLEAN%20Connect%20Windows%20Service/digilean-connect-windows/Connect.WindowsService.zip"
Write-Output "`n++++++++++ Download from: $url"

$filename = $(Split-Path -Path $url -Leaf)

Invoke-WebRequest -Uri $url -OutFile $filename
Write-Output "---------- Successfully downloaded $filename"

Write-Output "...Stopping Service..."
Stop-Service "DigiLean Connect Service"

Write-Output "++++++++++ Extracting to $extract_to"
Expand-Archive -LiteralPath $filename -DestinationPath $extract_to

Write-Output "---------- Moving old files to to $backup_to"
$files_to_move = "*.dll","*.exe","*.pdb","*.runtimeconfig.json", "*.deps.json"

foreach ($files in $files_to_move)
{
    $backup_filter = $local_folder + $files
    Move-Item -Path $backup_filter -Destination $backup_to
}

Write-Output "++++++++++ Moving extracted files to $local_folder"
foreach ($files in $files_to_move)
{
    $move_filter = $extract_to + $files
    Move-Item -Path $move_filter -Destination $local_folder
}

Write-Output "...Starting Service..."
Start-Service "DigiLean Connect Service"

Write-Output "---------- Done. Press any key to exit"
$Host.UI.RawUI.ReadKey()